#include "core.h"
#include "process.h"
#include "master.h"
#include "sparccore.h"
#include "m68kcore.h"
#include "mipscore.h"
#include "i386core.h"
#include "dbmonitor/dbmonitor.h"
#include "rt.h"
#include "unix.h"
SRCFILE("unixconf.c")

class SparcUnixCore : public SparcCore, public UnixCore {
public:
	SparcUnixCore(int f,int b,int p,Process *pr,Master *m):
		Core(pr,m), UnixCore(f,b,p)	{}
};

class M68kUnixCore : public M68kCore, public UnixCore {
public:
	M68kUnixCore(int f,int b,int p,Process *pr,Master *m):
		Core(pr,m), UnixCore(f,b,p)	{}
};

class MipsUnixCore : public MipsCore, public UnixCore {
public:
	MipsUnixCore(int f,int b,int p,Process *pr,Master *m):
		Core(pr,m), UnixCore(f,b,p)	{}
};

class I386UnixCore : public I386Core, public UnixCore {
public:
	I386UnixCore(int f,int b,int p,Process *pr,Master *m):
		Core(pr,m), UnixCore(f,b,p)	{}
};

Core *UnixProcess::newCore(Master *m)
{
	Core *c = 0;
	DebugAttrib dba;
	::dbrequest(fd, boardid, DB_KERNELID, DBR_GETATTRIB,
		    (int)&dba, 0, sizeof(dba));
	db_ntohsa(&dba.machine, 3);
	switch (dba.machine) {
	case DBMT_SPARC:
		c = new SparcUnixCore(fd, boardid, pipeid, this, m);
		break;
	case DBMT_68020:
		c = new M68kUnixCore(fd, boardid, pipeid, this, m);
		break;
	case DBMT_MIPSR3000:
		c = new MipsUnixCore(fd, boardid, pipeid, this, m);
		break;
	case DBMT_I386:
		c = new I386UnixCore(fd, boardid, pipeid, this, m);
		break;
	
	}
	return c;
}
